<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RolesPermission extends Model 
{

    protected $table = 'roles_permissions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('permisson_id', 'role_id', 'created_by', 'updated_by');

    public function permissions()
    {
        return $this->hasMany('App\Models\Permissions', 'permisson_id');
    }

    public function roles()
    {
        return $this->hasMany('App\Models\Role', 'role_id');
    }

}